/*
 * Decompiled with CFR 0.152.
 */
package jade.wrapper.gateway;

import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.core.behaviours.SequentialBehaviour;
import jade.util.Logger;
import jade.wrapper.gateway.GatewayBehaviour;

public class GatewayAgent
extends Agent {
    private GatewayBehaviour myB = null;
    private final Logger myLogger = Logger.getMyLogger(this.getClass().getName());

    protected void processCommand(final Object command) {
        if (command instanceof Behaviour) {
            SequentialBehaviour sb = new SequentialBehaviour(this);
            sb.addSubBehaviour((Behaviour)command);
            sb.addSubBehaviour(new OneShotBehaviour(this){

                public void action() {
                    GatewayAgent.this.releaseCommand(command);
                }
            });
            this.addBehaviour(sb);
        } else {
            this.myLogger.log(Logger.WARNING, "Unknown command " + command);
        }
    }

    public final void releaseCommand(Object command) {
        this.myB.releaseCommand(command);
    }

    public GatewayAgent() {
        this.setEnabledO2ACommunication(true, 0);
    }

    protected void setup() {
        if (this.myLogger.isLoggable(Logger.INFO)) {
            this.myLogger.log(Logger.INFO, "Started GatewayAgent " + this.getLocalName());
        }
        this.myB = new GatewayBehaviour(){

            protected void processCommand(Object command) {
                ((GatewayAgent)this.myAgent).processCommand(command);
            }
        };
        this.addBehaviour(this.myB);
    }
}

